using System;
using System.Linq;
using System.Data;
using System.Data.SqlClient;
using System.Reflection;
using System.Collections;
using gov.va.med.vbecs.ExceptionManagement;
using TABLE = gov.va.med.vbecs.Common.VbecsTables;
using STOREDPROC = gov.va.med.vbecs.Common.VbecsStoredProcs;
using ARTIFICIAL = gov.va.med.vbecs.Common.DatabaseConstants.ArtificialColumnNames;
using gov.va.med.vbecs.Common;
using System.Collections.Generic;

namespace gov.va.med.vbecs.DAL
{

    #region Header

    ///<Package>Package: VBECS - VistA Blood Establishment Computer System</Package>
    ///<Warning> WARNING: Per VHA Directive $VADIRECTIVE this class should not be modified</Warning>
    ///<MedicalDevice> Medical Device #: $MEDDEVICENO</MedicalDevice>
    ///<Developers>
    ///	<Developer>Doug Forst</Developer>
    ///</Developers>
    ///<SiteName></SiteName>
    ///<CreationDate>12/29/2015</CreationDate>
    ///<Note>The Food and Drug Administration classifies this software as a medical device.  As such, it may not be changed in any way. Modifications to this software may result in an adulterated medical device under 21CFR820, the use of which is considered to be a violation of US Federal Statutes.  Acquiring and implementing this software through the Freedom of information Act requires the implementor to assume total responsibility for the software, and become a registered manufacturer of a medical device, subject to FDA regulations</Note>
    ///<summary>
    ///	Data access component providing database read/write functionality for
    ///	pending specimen tests received from an automated instrument.
    ///</summary>

    #endregion
    public class PendingSpecimenTest
    {
        ///<Developers>
        ///	<Developer>Doug Forst</Developer>
        ///</Developers>
        ///<SiteName></SiteName>
        ///<CreationDate>12/29/2015</CreationDate>
        ///<summary>
        /// Gets count of pending specimen tests for a given division code and pending test status id
        ///</summary>
        ///<param name="divisionCode">Division Code</param>
        ///<param name="pendingTestStatus">Pending Test Status</param>
        ///<returns>Count of pending specimen tests</returns>
        public static int GetCount(string divisionCode, PendingTestStatus pendingTestStatus)
        {
            IList<SqlParameter> prms = new List<SqlParameter>()
				{
                    StoredProcedure.MakeParameter(STOREDPROC.GetPendingSpecimenTestsCount.divisioncode, divisionCode),
                    StoredProcedure.MakeParameter(STOREDPROC.GetPendingSpecimenTestsCount.pendingteststatusid, (byte)pendingTestStatus),
				};

            return int.Parse(StoredProcedure.GetSingleDataRow(STOREDPROC.GetPendingSpecimenTestsCount.StoredProcName, prms.ToArray())[0].ToString());
        }

        ///<Developers>
        ///	<Developer>Doug Forst</Developer>
        ///</Developers>
        ///<SiteName></SiteName>
        ///<CreationDate>01/18/2016</CreationDate>
        ///<summary>
        /// Gets pending specimen test results for a given division code and pending test status id
        ///</summary>
        ///<param name="divisionCode">Division Code</param>
        ///<param name="pendingTestStatus">Pending Test Status</param>
        ///<returns>DataTable containing pending blood unit test results</returns>
        public static DataSet GetPatientsWithPendingSpecimenTests(string divisionCode, PendingTestStatus pendingTestStatus)
        {
            IList<SqlParameter> prms = new List<SqlParameter>()
				{
                    StoredProcedure.MakeParameter(STOREDPROC.GetPatientsWithPendingSpecimenTests.DivisionCode, divisionCode),
                    StoredProcedure.MakeParameter(STOREDPROC.GetPatientsWithPendingSpecimenTests.PendingTestStatusId, (byte)pendingTestStatus),
				};

            return Common.StoredProcedure.GetData(STOREDPROC.GetPatientsWithPendingSpecimenTests.StoredProcName, prms.ToArray());
        }

        ///<Developers>
        ///<Developer>Doug Forst</Developer>
        ///</Developers>
        ///<SiteName></SiteName>
        ///<CreationDate>01/20/2016</CreationDate>
        ///<summary>
        /// Gets pending specimen test results for a given specimentUid, division code and pending test status id
        ///</summary>
        ///<param name="patientGuid">Patient Guid</param>
        ///<param name="patientSpecimenGuid">SpecimenUid</param>
        ///<param name="divisionCode">Division Code</param>
        ///<param name="pendingTestStatus">Pending Test Status</param>
        ///<param name="orderableTest">Orderable Test (optional)</param>
        ///<returns>DataTable containing pending blood unit test results</returns>
        public static DataSet GetPendingSpecimenTests(Guid patientGuid, Guid patientSpecimenGuid, string divisionCode, PendingTestStatus pendingTestStatus, OrderableTest? orderableTest)
        {
            IList<SqlParameter> prms = new List<SqlParameter>()
				{
                    StoredProcedure.MakeParameter(STOREDPROC.GetPendingSpecimenTests.PatientSpecimenGuid, patientSpecimenGuid),
                    StoredProcedure.MakeParameter(STOREDPROC.GetPendingSpecimenTests.PatientGuid, patientGuid),
                    StoredProcedure.MakeParameter(STOREDPROC.GetPendingSpecimenTests.DivisionCode, divisionCode),
                    StoredProcedure.MakeParameter(STOREDPROC.GetPendingSpecimenTests.PendingTestStatusId, (byte)pendingTestStatus),
                    StoredProcedure.MakeParameter(STOREDPROC.GetPendingSpecimenTests.OrderableTestId, orderableTest.HasValue ? (int?)orderableTest.Value : null, SqlDbType.Int)
				};

            return Common.StoredProcedure.GetData(STOREDPROC.GetPendingSpecimenTests.StoredProcName, prms.ToArray());
        }

        ///<Developers>
        ///	<Developer>Doug Forst</Developer>
        ///</Developers>
        ///<SiteName></SiteName>
        ///<CreationDate>01/21/2016</CreationDate>
        /// <summary>
        /// Update pending specimen tests
        /// </summary>
        /// <param name="dtUpdatePendingSpecimenTest"></param>
        public static bool Update(DataTable dtUpdatePendingSpecimenTest)
        {
            return (new StoredProcedure().TransactionalGetValue(STOREDPROC.UpdatePendingSpecimenTest.StoredProcName, dtUpdatePendingSpecimenTest) == 0);
        }
    }
}